/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;

public class NativeToJsMessageQueue {
    private static final String LOG_TAG = "JsMessageQueue";
    private static final boolean FORCE_ENCODE_USING_EVAL = false;
    static final boolean DISABLE_EXEC_CHAINING = false;
    private static int MAX_PAYLOAD_SIZE = 524288000;
    private boolean paused;
    private final LinkedList<JsMessage> queue = new LinkedList();
    private ArrayList<BridgeMode> bridgeModes = new ArrayList();
    private BridgeMode activeBridgeMode;

    public void addBridgeMode(BridgeMode bridgeMode) {
        this.bridgeModes.add(bridgeMode);
    }

    public boolean isBridgeEnabled() {
        return this.activeBridgeMode != null;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBridgeMode(int value) {
        if (value < -1 || value >= this.bridgeModes.size()) {
            LOG.d(LOG_TAG, "Invalid NativeToJsBridgeMode: " + value);
        } else {
            BridgeMode newMode;
            BridgeMode bridgeMode = newMode = value < 0 ? null : this.bridgeModes.get(value);
            if (newMode != this.activeBridgeMode) {
                LOG.d(LOG_TAG, "Set native->JS mode to " + (newMode == null ? "null" : newMode.getClass().getSimpleName()));
                NativeToJsMessageQueue nativeToJsMessageQueue = this;
                synchronized (nativeToJsMessageQueue) {
                    this.activeBridgeMode = newMode;
                    if (newMode != null) {
                        newMode.reset();
                        if (!this.paused && !this.queue.isEmpty()) {
                            newMode.onNativeToJsMessageAvailable(this);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            this.queue.clear();
            this.setBridgeMode(-1);
        }
    }

    private int calculatePackedMessageLength(JsMessage message) {
        int messageLen = message.calculateEncodedLength();
        String messageLenStr = String.valueOf(messageLen);
        return messageLenStr.length() + messageLen + 1;
    }

    private void packMessage(JsMessage message, StringBuilder sb) {
        int len = message.calculateEncodedLength();
        sb.append(len).append(' ');
        message.encodeAsMessage(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popAndEncode(boolean fromOnlineEvent) {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            if (this.activeBridgeMode == null) {
                return null;
            }
            this.activeBridgeMode.notifyOfFlush(this, fromOnlineEvent);
            if (this.queue.isEmpty()) {
                return null;
            }
            int totalPayloadLen = 0;
            int numMessagesToSend = 0;
            for (JsMessage message : this.queue) {
                int messageSize = this.calculatePackedMessageLength(message);
                if (numMessagesToSend > 0 && totalPayloadLen + messageSize > MAX_PAYLOAD_SIZE && MAX_PAYLOAD_SIZE > 0) break;
                totalPayloadLen += messageSize;
                ++numMessagesToSend;
            }
            StringBuilder sb = new StringBuilder(totalPayloadLen);
            for (int i = 0; i < numMessagesToSend; ++i) {
                JsMessage message = this.queue.removeFirst();
                this.packMessage(message, sb);
            }
            if (!this.queue.isEmpty()) {
                sb.append('*');
            }
            String ret = sb.toString();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String popAndEncodeAsJs() {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            int i;
            int length = this.queue.size();
            if (length == 0) {
                return null;
            }
            int totalPayloadLen = 0;
            int numMessagesToSend = 0;
            for (JsMessage message : this.queue) {
                int messageSize = message.calculateEncodedLength() + 50;
                if (numMessagesToSend > 0 && totalPayloadLen + messageSize > MAX_PAYLOAD_SIZE && MAX_PAYLOAD_SIZE > 0) break;
                totalPayloadLen += messageSize;
                ++numMessagesToSend;
            }
            boolean willSendAllMessages = numMessagesToSend == this.queue.size();
            StringBuilder sb = new StringBuilder(totalPayloadLen + (willSendAllMessages ? 0 : 100));
            for (i = 0; i < numMessagesToSend; ++i) {
                JsMessage message = this.queue.removeFirst();
                if (willSendAllMessages && i + 1 == numMessagesToSend) {
                    message.encodeAsJsMessage(sb);
                    continue;
                }
                sb.append("try{");
                message.encodeAsJsMessage(sb);
                sb.append("}finally{");
            }
            if (!willSendAllMessages) {
                sb.append("window.setTimeout(function(){cordova.require('cordova/plugin/android/polling').pollOnce();},0);");
            }
            int n = i = willSendAllMessages ? 1 : 0;
            while (i < numMessagesToSend) {
                sb.append('}');
                ++i;
            }
            String ret = sb.toString();
            return ret;
        }
    }

    public void addJavaScript(String statement) {
        this.enqueueMessage(new JsMessage(statement));
    }

    public void addPluginResult(PluginResult result, String callbackId) {
        if (callbackId == null) {
            LOG.e(LOG_TAG, "Got plugin result with no callbackId", new Throwable());
            return;
        }
        boolean noResult = result.getStatus() == PluginResult.Status.NO_RESULT.ordinal();
        boolean keepCallback = result.getKeepCallback();
        if (noResult && keepCallback) {
            return;
        }
        JsMessage message = new JsMessage(result, callbackId);
        this.enqueueMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessage(JsMessage message) {
        NativeToJsMessageQueue nativeToJsMessageQueue = this;
        synchronized (nativeToJsMessageQueue) {
            if (this.activeBridgeMode == null) {
                LOG.d(LOG_TAG, "Dropping Native->JS message due to disabled bridge");
                return;
            }
            this.queue.add(message);
            if (!this.paused) {
                this.activeBridgeMode.onNativeToJsMessageAvailable(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean value) {
        if (this.paused && value) {
            LOG.e(LOG_TAG, "nested call to setPaused detected.", new Throwable());
        }
        this.paused = value;
        if (!value) {
            NativeToJsMessageQueue nativeToJsMessageQueue = this;
            synchronized (nativeToJsMessageQueue) {
                if (!this.queue.isEmpty() && this.activeBridgeMode != null) {
                    this.activeBridgeMode.onNativeToJsMessageAvailable(this);
                }
            }
        }
    }

    private static class JsMessage {
        final String jsPayloadOrCallbackId;
        final PluginResult pluginResult;

        JsMessage(String js) {
            if (js == null) {
                throw new NullPointerException();
            }
            this.jsPayloadOrCallbackId = js;
            this.pluginResult = null;
        }

        JsMessage(PluginResult pluginResult, String callbackId) {
            if (callbackId == null || pluginResult == null) {
                throw new NullPointerException();
            }
            this.jsPayloadOrCallbackId = callbackId;
            this.pluginResult = pluginResult;
        }

        static int calculateEncodedLengthHelper(PluginResult pluginResult) {
            switch (pluginResult.getMessageType()) {
                case 4: 
                case 5: {
                    return 1;
                }
                case 3: {
                    return 1 + pluginResult.getMessage().length();
                }
                case 1: {
                    return 1 + pluginResult.getStrMessage().length();
                }
                case 7: {
                    return 1 + pluginResult.getMessage().length();
                }
                case 6: {
                    return 1 + pluginResult.getMessage().length();
                }
                case 8: {
                    int ret = 1;
                    for (int i = 0; i < pluginResult.getMultipartMessagesSize(); ++i) {
                        int length = JsMessage.calculateEncodedLengthHelper(pluginResult.getMultipartMessage(i));
                        int argLength = String.valueOf(length).length();
                        ret += argLength + 1 + length;
                    }
                    return ret;
                }
            }
            return pluginResult.getMessage().length();
        }

        int calculateEncodedLength() {
            if (this.pluginResult == null) {
                return this.jsPayloadOrCallbackId.length() + 1;
            }
            int statusLen = String.valueOf(this.pluginResult.getStatus()).length();
            int ret = 2 + statusLen + 1 + this.jsPayloadOrCallbackId.length() + 1;
            return ret + JsMessage.calculateEncodedLengthHelper(this.pluginResult);
        }

        static void encodeAsMessageHelper(StringBuilder sb, PluginResult pluginResult) {
            switch (pluginResult.getMessageType()) {
                case 4: {
                    sb.append(pluginResult.getMessage().charAt(0));
                    break;
                }
                case 5: {
                    sb.append('N');
                    break;
                }
                case 3: {
                    sb.append('n').append(pluginResult.getMessage());
                    break;
                }
                case 1: {
                    sb.append('s');
                    sb.append(pluginResult.getStrMessage());
                    break;
                }
                case 7: {
                    sb.append('S');
                    sb.append(pluginResult.getMessage());
                    break;
                }
                case 6: {
                    sb.append('A');
                    sb.append(pluginResult.getMessage());
                    break;
                }
                case 8: {
                    sb.append('M');
                    for (int i = 0; i < pluginResult.getMultipartMessagesSize(); ++i) {
                        PluginResult multipartMessage = pluginResult.getMultipartMessage(i);
                        sb.append(String.valueOf(JsMessage.calculateEncodedLengthHelper(multipartMessage)));
                        sb.append(' ');
                        JsMessage.encodeAsMessageHelper(sb, multipartMessage);
                    }
                    break;
                }
                default: {
                    sb.append(pluginResult.getMessage());
                }
            }
        }

        void encodeAsMessage(StringBuilder sb) {
            if (this.pluginResult == null) {
                sb.append('J').append(this.jsPayloadOrCallbackId);
                return;
            }
            int status = this.pluginResult.getStatus();
            boolean noResult = status == PluginResult.Status.NO_RESULT.ordinal();
            boolean resultOk = status == PluginResult.Status.OK.ordinal();
            boolean keepCallback = this.pluginResult.getKeepCallback();
            sb.append(noResult || resultOk ? (char)'S' : 'F').append(keepCallback ? (char)'1' : '0').append(status).append(' ').append(this.jsPayloadOrCallbackId).append(' ');
            JsMessage.encodeAsMessageHelper(sb, this.pluginResult);
        }

        void encodeAsJsMessage(StringBuilder sb) {
            if (this.pluginResult == null) {
                sb.append(this.jsPayloadOrCallbackId);
            } else {
                int status = this.pluginResult.getStatus();
                boolean success = status == PluginResult.Status.OK.ordinal() || status == PluginResult.Status.NO_RESULT.ordinal();
                sb.append("cordova.callbackFromNative('").append(this.jsPayloadOrCallbackId).append("',").append(success).append(",").append(status).append(",[");
                switch (this.pluginResult.getMessageType()) {
                    case 7: {
                        sb.append("atob('").append(this.pluginResult.getMessage()).append("')");
                        break;
                    }
                    case 6: {
                        sb.append("cordova.require('cordova/base64').toArrayBuffer('").append(this.pluginResult.getMessage()).append("')");
                        break;
                    }
                    default: {
                        sb.append(this.pluginResult.getMessage());
                    }
                }
                sb.append("],").append(this.pluginResult.getKeepCallback()).append(");");
            }
        }
    }

    public static class EvalBridgeMode
    extends BridgeMode {
        private final CordovaWebViewEngine engine;
        private final CordovaInterface cordova;

        public EvalBridgeMode(CordovaWebViewEngine engine, CordovaInterface cordova) {
            this.engine = engine;
            this.cordova = cordova;
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue queue) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String js = queue.popAndEncodeAsJs();
                    if (js != null) {
                        EvalBridgeMode.this.engine.evaluateJavascript(js, null);
                    }
                }
            });
        }
    }

    public static class OnlineEventsBridgeMode
    extends BridgeMode {
        private final OnlineEventsBridgeModeDelegate delegate;
        private boolean online;
        private boolean ignoreNextFlush;

        public OnlineEventsBridgeMode(OnlineEventsBridgeModeDelegate delegate) {
            this.delegate = delegate;
        }

        @Override
        public void reset() {
            this.delegate.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    OnlineEventsBridgeMode.this.online = false;
                    OnlineEventsBridgeMode.this.ignoreNextFlush = true;
                    OnlineEventsBridgeMode.this.delegate.setNetworkAvailable(true);
                }
            });
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue queue) {
            this.delegate.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!queue.isEmpty()) {
                        OnlineEventsBridgeMode.this.ignoreNextFlush = false;
                        OnlineEventsBridgeMode.this.delegate.setNetworkAvailable(OnlineEventsBridgeMode.this.online);
                    }
                }
            });
        }

        @Override
        public void notifyOfFlush(NativeToJsMessageQueue queue, boolean fromOnlineEvent) {
            if (fromOnlineEvent && !this.ignoreNextFlush) {
                this.online = !this.online;
            }
        }

        public static interface OnlineEventsBridgeModeDelegate {
            public void setNetworkAvailable(boolean var1);

            public void runOnUiThread(Runnable var1);
        }
    }

    public static class LoadUrlBridgeMode
    extends BridgeMode {
        private final CordovaWebViewEngine engine;
        private final CordovaInterface cordova;

        public LoadUrlBridgeMode(CordovaWebViewEngine engine, CordovaInterface cordova) {
            this.engine = engine;
            this.cordova = cordova;
        }

        @Override
        public void onNativeToJsMessageAvailable(final NativeToJsMessageQueue queue) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String js = queue.popAndEncodeAsJs();
                    if (js != null) {
                        LoadUrlBridgeMode.this.engine.loadUrl("javascript:" + js, false);
                    }
                }
            });
        }
    }

    public static class NoOpBridgeMode
    extends BridgeMode {
        @Override
        public void onNativeToJsMessageAvailable(NativeToJsMessageQueue queue) {
        }
    }

    public static abstract class BridgeMode {
        public abstract void onNativeToJsMessageAvailable(NativeToJsMessageQueue var1);

        public void notifyOfFlush(NativeToJsMessageQueue queue, boolean fromOnlineEvent) {
        }

        public void reset() {
        }
    }
}

