"use strict";
var path_1 = require('path');
var helpers_1 = require('../util/helpers');
module.exports = function typescriptSourcemapLoaderMemory(source, map) {
    this.cacheable();
    var callback = this.async();
    var context = helpers_1.getContext();
    var absolutePath = path_1.resolve(path_1.normalize(this.resourcePath));
    var javascriptPath = helpers_1.changeExtension(this.resourcePath, '.js');
    var sourceMapPath = javascriptPath + '.map';
    var javascriptFile = null;
    var mapFile = null;
    var promises = [];
    var readJavascriptFilePromise = readFile(context.fileCache, javascriptPath);
    promises.push(readJavascriptFilePromise);
    readJavascriptFilePromise.then(function (file) {
        javascriptFile = file;
    });
    var readJavascriptMapFilePromise = readFile(context.fileCache, sourceMapPath);
    promises.push(readJavascriptMapFilePromise);
    readJavascriptMapFilePromise.then(function (file) {
        mapFile = file;
    });
    Promise.all(promises).then(function () {
        var sourceMapObject = map;
        if (mapFile) {
            sourceMapObject = JSON.parse(mapFile.content);
            sourceMapObject.sources = [absolutePath];
            if (!sourceMapObject.sourcesContent || sourceMapObject.sourcesContent.length === 0) {
                sourceMapObject.sourcesContent = [source];
            }
        }
        callback(null, javascriptFile.content, sourceMapObject);
    });
};
function readFile(fileCache, filePath) {
    var file = fileCache.get(filePath);
    if (file) {
        return Promise.resolve(file);
    }
    return helpers_1.readFileAsync(filePath).then(function (fileContent) {
        var file = { path: filePath, content: fileContent };
        fileCache.set(filePath, file);
        return file;
    }).catch(function (err) {
        return null;
    });
}
