import { Avatar } from './components/avatar/avatar';
import { Backdrop } from './components/backdrop/backdrop';
import { Badge } from './components/badge/badge';
import { Button } from './components/button/button';
import { Card, CardContent, CardHeader, CardTitle } from './components/card/card';
import { Checkbox } from './components/checkbox/checkbox';
import { Chip } from './components/chip/chip';
import { ClickBlock } from './util/click-block';
import { Content } from './components/content/content';
import { DateTime } from './components/datetime/datetime';
import { FabContainer, FabButton, FabList } from './components/fab/fab';
import { Grid, Row, Col } from './components/grid/grid';
import { Icon } from './components/icon/icon';
import { Img } from './components/img/img';
import { InfiniteScroll } from './components/infinite-scroll/infinite-scroll';
import { InfiniteScrollContent } from './components/infinite-scroll/infinite-scroll-content';
import { IonicApp } from './components/app/app-root';
import { Item, ItemContent, ItemDivider, ItemGroup } from './components/item/item';
import { ItemReorder, Reorder } from './components/item/item-reorder';
import { ItemSliding, ItemOptions } from './components/item/item-sliding';
import { Label } from './components/label/label';
import { List } from './components/list/list';
import { ListHeader } from './components/list/list-header';
import { Menu } from './components/menu/menu';
import { MenuClose } from './components/menu/menu-close';
import { MenuToggle } from './components/menu/menu-toggle';
import { NativeInput, NextInput } from './components/input/native-input';
import { Nav } from './components/nav/nav';
import { NavPop, NavPopAnchor } from './components/nav/nav-pop';
import { NavPush, NavPushAnchor } from './components/nav/nav-push';
import { Navbar } from './components/navbar/navbar';
import { Note } from './components/note/note';
import { Option } from './components/option/option';
import { OverlayPortal } from './components/nav/overlay-portal';
import { PickerColumnCmp } from './components/picker/picker-component';
import { RadioButton } from './components/radio/radio-button';
import { RadioGroup } from './components/radio/radio-group';
import { Range, RangeKnob } from './components/range/range';
import { Refresher } from './components/refresher/refresher';
import { RefresherContent } from './components/refresher/refresher-content';
import { Scroll } from './components/scroll/scroll';
import { Searchbar } from './components/searchbar/searchbar';
import { Segment, SegmentButton } from './components/segment/segment';
import { Select } from './components/select/select';
import { ShowWhen, HideWhen } from './components/show-hide-when/show-hide-when';
import { Slides, Slide, SlideLazy } from './components/slides/slides';
import { Spinner } from './components/spinner/spinner';
import { Tab } from './components/tabs/tab';
import { Tabs } from './components/tabs/tabs';
import { TabButton } from './components/tabs/tab-button';
import { TabHighlight } from './components/tabs/tab-highlight';
import { TextInput, TextArea } from './components/input/input';
import { Thumbnail } from './components/thumbnail/thumbnail';
import { Toggle } from './components/toggle/toggle';
import { Toolbar, Header, Footer } from './components/toolbar/toolbar';
import { ToolbarItem } from './components/toolbar/toolbar-item';
import { ToolbarTitle } from './components/toolbar/toolbar-title';
import { Typography } from './components/typography/typography';
import { VirtualScroll } from './components/virtual-scroll/virtual-scroll';
import { VirtualItem, VirtualHeader, VirtualFooter } from './components/virtual-scroll/virtual-item';
/**
 * Export Abstract Class Components
 */
export { Ion } from './components/ion';
/**
 * Export Components
 */
export { ActionSheet, ActionSheetController } from './components/action-sheet/action-sheet';
export { Alert, AlertController } from './components/alert/alert';
export { App } from './components/app/app';
export { Avatar } from './components/avatar/avatar';
export { Backdrop } from './components/backdrop/backdrop';
export { Badge } from './components/badge/badge';
export { Button } from './components/button/button';
export { Card, CardContent, CardHeader, CardTitle } from './components/card/card';
export { Checkbox } from './components/checkbox/checkbox';
export { Chip } from './components/chip/chip';
export { ClickBlock } from './util/click-block';
export { Content } from './components/content/content';
export { DateTime } from './components/datetime/datetime';
export { FabContainer, FabButton, FabList } from './components/fab/fab';
export { Grid, Row, Col } from './components/grid/grid';
export { Icon } from './components/icon/icon';
export { Img } from './components/img/img';
export { InfiniteScroll } from './components/infinite-scroll/infinite-scroll';
export { InfiniteScrollContent } from './components/infinite-scroll/infinite-scroll-content';
export { TextArea, TextInput } from './components/input/input';
export { IonicApp } from './components/app/app-root';
export { Item, ItemContent, ItemDivider, ItemGroup } from './components/item/item';
export { ItemReorder, Reorder } from './components/item/item-reorder';
export { ItemSliding, ItemOptions } from './components/item/item-sliding';
export { Label } from './components/label/label';
export { List } from './components/list/list';
export { ListHeader } from './components/list/list-header';
export { Loading, LoadingController } from './components/loading/loading';
export { Menu } from './components/menu/menu';
export { MenuClose } from './components/menu/menu-close';
export { MenuController } from './components/menu/menu-controller';
export { MenuToggle } from './components/menu/menu-toggle';
export { MenuType } from './components/menu/menu-types';
export { Modal, ModalController } from './components/modal/modal';
export { Nav } from './components/nav/nav';
export { NavPop, NavPopAnchor } from './components/nav/nav-pop';
export { NavPush, NavPushAnchor } from './components/nav/nav-push';
export { Navbar } from './components/navbar/navbar';
export { NativeInput, NextInput } from './components/input/native-input';
export { Note } from './components/note/note';
export { Option } from './components/option/option';
export { OverlayPortal } from './components/nav/overlay-portal';
export { Picker, PickerController } from './components/picker/picker';
export { Popover, PopoverController } from './components/popover/popover';
export { RadioButton } from './components/radio/radio-button';
export { RadioGroup } from './components/radio/radio-group';
export { Range, RangeKnob } from './components/range/range';
export { Refresher } from './components/refresher/refresher';
export { RefresherContent } from './components/refresher/refresher-content';
export { Scroll } from './components/scroll/scroll';
export { Searchbar } from './components/searchbar/searchbar';
export { Segment, SegmentButton } from './components/segment/segment';
export { Select } from './components/select/select';
export { ShowWhen, HideWhen, DisplayWhen } from './components/show-hide-when/show-hide-when';
export { Slides, Slide, SlideLazy } from './components/slides/slides';
export { Spinner } from './components/spinner/spinner';
export { Tab } from './components/tabs/tab';
export { Tabs } from './components/tabs/tabs';
export { TabButton } from './components/tabs/tab-button';
export { TabHighlight } from './components/tabs/tab-highlight';
export { TapClick, isActivatable } from './components/tap-click/tap-click';
export { Toast, ToastController } from './components/toast/toast';
export { Toggle } from './components/toggle/toggle';
export { Toolbar, ToolbarBase, Header, Footer } from './components/toolbar/toolbar';
export { ToolbarItem } from './components/toolbar/toolbar-item';
export { ToolbarTitle } from './components/toolbar/toolbar-title';
export { Thumbnail } from './components/thumbnail/thumbnail';
export { Typography } from './components/typography/typography';
export { VirtualScroll } from './components/virtual-scroll/virtual-scroll';
export { ActionSheetCmp } from './components/action-sheet/action-sheet-component';
export { AlertCmp } from './components/alert/alert-component';
export { LoadingCmp } from './components/loading/loading-component';
export { ModalCmp } from './components/modal/modal-component';
export { PickerCmp, PickerColumnCmp } from './components/picker/picker-component';
export { PopoverCmp } from './components/popover/popover-component';
export { ToastCmp } from './components/toast/toast-component';
/**
 * @private
 * @name IONIC_DIRECTIVES
 * @description
 * The core Ionic directives are automatically available when you bootstrap your app
 * with the `IonicModule`. This means if you are using custom components you do not
 * need to import `IONIC_DIRECTIVES` as they are part of the app's default directives.
 */
export const IONIC_DIRECTIVES = [
    Avatar,
    Backdrop,
    Badge,
    Button,
    Card,
    CardContent,
    CardHeader,
    CardTitle,
    Checkbox,
    Chip,
    ClickBlock,
    Col,
    Content,
    DateTime,
    FabContainer,
    FabButton,
    FabList,
    Footer,
    Grid,
    Header,
    HideWhen,
    Icon,
    Img,
    InfiniteScroll,
    InfiniteScrollContent,
    IonicApp,
    Item,
    ItemContent,
    ItemDivider,
    ItemGroup,
    ItemOptions,
    ItemReorder,
    ItemSliding,
    Label,
    List,
    ListHeader,
    Menu,
    MenuClose,
    MenuToggle,
    NativeInput,
    Nav,
    Navbar,
    NavPop,
    NavPopAnchor,
    NavPush,
    NavPushAnchor,
    NextInput,
    Note,
    Option,
    OverlayPortal,
    PickerColumnCmp,
    RadioButton,
    RadioGroup,
    Range,
    RangeKnob,
    Refresher,
    RefresherContent,
    Reorder,
    Row,
    Scroll,
    Searchbar,
    Segment,
    SegmentButton,
    Select,
    ShowWhen,
    Slide,
    Slides,
    SlideLazy,
    Spinner,
    Tab,
    Tabs,
    TabButton,
    TabHighlight,
    TextArea,
    TextInput,
    Thumbnail,
    Toggle,
    Toolbar,
    ToolbarItem,
    ToolbarTitle,
    Typography,
    VirtualFooter,
    VirtualHeader,
    VirtualItem,
    VirtualScroll,
];
//# sourceMappingURL=directives.js.map