import { OpaqueToken } from '@angular/core';
/**
 * @private
 */
export class QueryParams {
    constructor(url) {
        this.data = {};
        if (url) {
            const startIndex = url.indexOf('?');
            if (startIndex > -1) {
                const queries = url.slice(startIndex + 1).split('&');
                for (var i = 0; i < queries.length; i++) {
                    if (queries[i].indexOf('=') > 0) {
                        var split = queries[i].split('=');
                        if (split.length > 1) {
                            this.data[split[0].toLowerCase()] = split[1].split('#')[0];
                        }
                    }
                }
            }
        }
    }
    get(key) {
        return this.data[key.toLowerCase()];
    }
}
/**
 * @private
 */
export const UrlToken = new OpaqueToken('USERURL');
/**
 * @private
 */
export function setupQueryParams(url) {
    return new QueryParams(url);
}
//# sourceMappingURL=query-params.js.map