import { Animation } from '../animations/animation';
/**
 * @private
 *
 * - play
 * - Add before classes - DOM WRITE
 * - Remove before classes - DOM WRITE
 * - Add before inline styles - DOM WRITE
 * - set inline FROM styles - DOM WRITE
 * - RAF
 * - read toolbar dimensions - DOM READ
 * - write content top/bottom padding - DOM WRITE
 * - set css transition duration/easing - DOM WRITE
 * - RAF
 * - set inline TO styles - DOM WRITE
 */
export class Transition extends Animation {
    constructor(enteringView, leavingView, opts, raf) {
        super(null, opts, raf);
        this.enteringView = enteringView;
        this.leavingView = leavingView;
    }
    init() { }
    registerStart(trnsStart) {
        this._trnsStart = trnsStart;
    }
    isRoot() {
        return !this.parent;
    }
    start() {
        this._trnsStart && this._trnsStart();
        this._trnsStart = null;
    }
    destroy() {
        super.destroy();
        this.enteringView = this.leavingView = this._trnsStart = null;
    }
}
//# sourceMappingURL=transition.js.map