var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { PanGesture } from './drag-gesture';
import { clamp } from '../util/util';
import { pointerCoord } from '../util/dom';
/**
 * @private
 */
export var SlideGesture = (function (_super) {
    __extends(SlideGesture, _super);
    function SlideGesture(element, opts) {
        if (opts === void 0) { opts = {}; }
        _super.call(this, element, opts);
        this.slide = null;
    }
    /*
     * Get the min and max for the slide. pageX/pageY.
     * Only called on dragstart.
     */
    SlideGesture.prototype.getSlideBoundaries = function (slide, ev) {
        return {
            min: 0,
            max: this.getNativeElement().offsetWidth
        };
    };
    /*
     * Get the element's pos when the drag starts.
     * For example, an open side menu starts at 100% and a closed
     * sidemenu starts at 0%.
     */
    SlideGesture.prototype.getElementStartPos = function (slide, ev) {
        return 0;
    };
    SlideGesture.prototype.onDragStart = function (ev) {
        this.onSlideBeforeStart(ev);
        var coord = pointerCoord(ev);
        var pos = coord[this.direction];
        this.slide = {
            min: 0,
            max: 0,
            pointerStartPos: pos,
            pos: pos,
            timestamp: Date.now(),
            elementStartPos: 0,
            started: true,
            delta: 0,
            distance: 0,
            velocity: 0,
        };
        // TODO: we should run this in the next frame
        var _a = this.getSlideBoundaries(this.slide, ev), min = _a.min, max = _a.max;
        this.slide.min = min;
        this.slide.max = max;
        this.slide.elementStartPos = this.getElementStartPos(this.slide, ev);
        this.onSlideStart(this.slide, ev);
    };
    SlideGesture.prototype.onDragMove = function (ev) {
        var slide = this.slide;
        (void 0) /* assert */;
        var coord = pointerCoord(ev);
        var newPos = coord[this.direction];
        var newTimestamp = Date.now();
        var velocity = (newPos - slide.pos) / (newTimestamp - slide.timestamp);
        slide.pos = newPos;
        slide.timestamp = newTimestamp;
        slide.distance = clamp(slide.min, newPos - slide.pointerStartPos + slide.elementStartPos, slide.max);
        slide.velocity = velocity;
        slide.delta = newPos - slide.pointerStartPos;
        this.onSlide(slide, ev);
    };
    SlideGesture.prototype.onDragEnd = function (ev) {
        this.onSlideEnd(this.slide, ev);
        this.slide = null;
    };
    SlideGesture.prototype.onSlideBeforeStart = function (ev) { };
    SlideGesture.prototype.onSlideStart = function (slide, ev) { };
    SlideGesture.prototype.onSlide = function (slide, ev) { };
    SlideGesture.prototype.onSlideEnd = function (slide, ev) { };
    return SlideGesture;
}(PanGesture));
//# sourceMappingURL=slide-gesture.js.map