import { Observable } from 'rxjs/Observable';
export declare class Geofence {
    static TransitionType: {
        ENTER: number;
        EXIT: number;
        BOTH: number;
    };
    static onTrasitionReceived: Function;
    /**
     * Initializes the plugin. User will be prompted to allow the app to use location and notifications.
     *
     * @returns {Promise<void>}
     */
    static initialize(): Promise<void>;
    /**
     * Adds a new geofence or array of geofences. For geofence object, see above.
     *
     * @returns {Promise<void>}
     */
    static addOrUpdate(geofences: Object | Array<Object>): Promise<void>;
    /**
     * Removes a geofence or array of geofences. `geofenceID` corresponds to one or more IDs specified when the
     * geofence was created.
     *
     * @returns {Promise<void>}
     */
    static remove(geofenceId: string | Array<string>): Promise<void>;
    /**
     * Removes all geofences.
     *
     * @returns {Promise<void>}
     */
    static removeAll(): Promise<void>;
    /**
     * Returns an array of geofences currently being monitored.
     *
     * @returns {Promise<Array<string>>}
     */
    static getWatched(): Promise<string>;
    /**
     * Called when a geofence is crossed in the direction specified by `TransitType`.
     *
     * @returns {Observable<any>}
     */
    static onTransitionReceived(): Observable<any>;
    /**
     * Called when the user clicks a geofence notification. iOS and Android only.
     *
     * @returns {Observable<any>}
     */
    static onNotificationClicked(): Observable<any>;
}
