var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Cordova, Plugin } from './plugin';
import { Observable } from 'rxjs/Observable';
export var Geofence = (function () {
    function Geofence() {
    }
    /**
     * Initializes the plugin. User will be prompted to allow the app to use location and notifications.
     *
     * @returns {Promise<void>}
     */
    Geofence.initialize = function () { return; };
    ;
    /**
     * Adds a new geofence or array of geofences. For geofence object, see above.
     *
     * @returns {Promise<void>}
     */
    Geofence.addOrUpdate = function (geofences) { return; };
    ;
    /**
     * Removes a geofence or array of geofences. `geofenceID` corresponds to one or more IDs specified when the
     * geofence was created.
     *
     * @returns {Promise<void>}
     */
    Geofence.remove = function (geofenceId) { return; };
    ;
    /**
     * Removes all geofences.
     *
     * @returns {Promise<void>}
     */
    Geofence.removeAll = function () { return; };
    ;
    /**
     * Returns an array of geofences currently being monitored.
     *
     * @returns {Promise<Array<string>>}
     */
    Geofence.getWatched = function () { return; };
    ;
    /**
     * Called when a geofence is crossed in the direction specified by `TransitType`.
     *
     * @returns {Observable<any>}
     */
    Geofence.onTransitionReceived = function () {
        return new Observable(function (observer) {
            window && window.geofence && (window.geofence.onTransitionReceived = observer.next.bind(observer));
            return function () { return window.geofence.onTransitionReceived = function () { }; };
        });
    };
    /**
     * Called when the user clicks a geofence notification. iOS and Android only.
     *
     * @returns {Observable<any>}
     */
    Geofence.onNotificationClicked = function () {
        return new Observable(function (observer) {
            window && window.geofence && (window.geofence.onNotificationClicked = observer.next.bind(observer));
            return function () { return window.geofence.onNotificationClicked = function () { }; };
        });
    };
    Geofence.TransitionType = {
        ENTER: 1,
        EXIT: 2,
        BOTH: 3
    };
    __decorate([
        Cordova()
    ], Geofence, "initialize", null);
    __decorate([
        Cordova()
    ], Geofence, "addOrUpdate", null);
    __decorate([
        Cordova()
    ], Geofence, "remove", null);
    __decorate([
        Cordova()
    ], Geofence, "removeAll", null);
    __decorate([
        Cordova()
    ], Geofence, "getWatched", null);
    Geofence = __decorate([
        Plugin({
            pluginName: 'Geofence',
            plugin: 'cordova-plugin-geofence',
            pluginRef: 'geofence',
            repo: 'https://github.com/cowbell/cordova-plugin-geofence/',
            platforms: ['Android', 'iOS', 'Windows Phone 8', 'Windows Phone']
        })
    ], Geofence);
    return Geofence;
}());
//# sourceMappingURL=geofence.js.map