var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Cordova, Plugin } from './plugin';
/**
 * @name Hotspot
 * @description
 * @usage
 * ```typescript
 * import { Hotspot, Network } from 'ionic-native';
 *
 *
 * Hotspot.scanWifi().then((networks: Array<Network>) => {
 *     console.log(networks);
 * });
 *
 * ```
 */
export var Hotspot = (function () {
    function Hotspot() {
    }
    /**
     * @returns {Promise<boolean>}
     */
    Hotspot.isAvailable = function () { return; };
    /**
     * @returns {Promise<boolean>}
     */
    Hotspot.toggleWifi = function () { return; };
    /**
     * Configures and starts hotspot with SSID and Password
     *
     * @param {string}    SSID        - SSID of your new Access Point
     * @param {string}    mode        - encryption mode (Open, WEP, WPA, WPA_PSK)
     * @param {string}    password    - password for your new Access Point
     *
     * @returns {Promise<void>}        - Promise to call once hotspot is started, or reject upon failure
     */
    Hotspot.createHotspot = function (ssid, mode, password) { return; };
    /**
     * Turns on Access Point
     *
     * @returns {Promise<boolean>} - true if AP is started
     */
    Hotspot.startHotspot = function () { return; };
    /**
     * Configures hotspot with SSID and Password
     *
     * @param {string}    SSID        - SSID of your new Access Point
     * @param {string}    mode        - encryption mode (Open, WEP, WPA, WPA_PSK)
     * @param {string}    password    - password for your new Access Point
     *
     * @returns {Promise<void>}        - Promise to call when hotspot is configured, or reject upon failure
     */
    Hotspot.configureHotspot = function (ssid, mode, password) { return; };
    /**
     * Turns off Access Point
     *
     * @returns {Promise<boolean>} - Promise to turn off the hotspot, true on success, false on failure
     */
    Hotspot.stopHotspot = function () { return; };
    /**
     * Checks if hotspot is enabled
     *
     * @returns {Promise<void>}    - Promise that hotspot is enabled, rejected if it is not enabled
     */
    Hotspot.isHotspotEnabled = function () { return; };
    /**
     * @returns {Promise<Array<HotspotDevice>>}
     */
    Hotspot.getAllHotspotDevices = function () { return; };
    /**
     * Connect to a WiFi network
     *
     * @param {string}    ssid
     *      SSID to connect
     * @param {string}    password
     *      password to use
     *
     * @returns {Promise<void>}
     *      Promise that connection to the WiFi network was successfull, rejected if unsuccessful
     */
    Hotspot.connectToWifi = function (ssid, password) { return; };
    /**
     * Connect to a WiFi network
     *
     * @param {string}   ssid
     *      SSID to connect
     * @param {string}   password
     *      Password to use
     * @param {string}   authentication
     *      Authentication modes to use (LEAP, SHARED, OPEN)
     * @param {string[]} encryption
     *      Encryption modes to use (CCMP, TKIP, WEP104, WEP40)
     *
     * @returns {Promise<void>}
     *      Promise that connection to the WiFi network was successfull, rejected if unsuccessful
     */
    Hotspot.connectToWifiAuthEncrypt = function (ssid, password, authentication, encryption) { return; };
    /**
     * Add a WiFi network
     *
     * @param {string}    ssid
     *      SSID of network
     * @param {string}    mode
     *      Authentication mode of (Open, WEP, WPA, WPA_PSK)
     * @param {string}    password
     *      Password for network
     *
     * @returns {Promise<void>}
     *      Promise that adding the WiFi network was successfull, rejected if unsuccessful
     */
    Hotspot.addWifiNetwork = function (ssid, mode, password) { return; };
    /**
     * Remove a WiFi network
     *
     * @param {string}    ssid
     *      SSID of network
     *
     * @returns {Promise<void>}
     *      Promise that removing the WiFi network was successfull, rejected if unsuccessful
     */
    Hotspot.removeWifiNetwork = function (ssid) { return; };
    /**
     * @returns {Promise<boolean>}
     */
    Hotspot.isConnectedToInternet = function () { return; };
    /**
     * @returns {Promise<boolean>}
     */
    Hotspot.isConnectedToInternetViaWifi = function () { return; };
    /**
     * @returns {Promise<boolean>}
     */
    Hotspot.isWifiOn = function () { return; };
    /**
     * @returns {Promise<boolean>}
     */
    Hotspot.isWifiSupported = function () { return; };
    /**
     * @returns {Promise<boolean>}
     */
    Hotspot.isWifiDirectSupported = function () { return; };
    /**
     * @returns {Promise<Array<HotspotNetwork>>}
     */
    Hotspot.scanWifi = function () { return; };
    /**
     * @returns {Promise<Array<HotspotNetwork>>}
     */
    Hotspot.scanWifiByLevel = function () { return; };
    /**
     * @returns {Promise<any>}
     */
    Hotspot.startWifiPeriodicallyScan = function (interval, duration) { return; };
    /**
     * @returns {Promise<any>}
     */
    Hotspot.stopWifiPeriodicallyScan = function () { return; };
    /**
     * @returns {Promise<HotspotNetworkConfig>}
     */
    Hotspot.getNetConfig = function () { return; };
    /**
     * @returns {Promise<ConnectionInfo>}
     */
    Hotspot.getConnectionInfo = function () { return; };
    /**
     * @returns {Promise<string>}
     */
    Hotspot.pingHost = function (ip) { return; };
    /**
     * Gets MAC Address associated with IP Address from ARP File
     *
     * @param {string}        ip  - IP Address that you want the MAC Address of
     *
     * @returns {Promise<string>}  - A Promise for the MAC Address
     */
    Hotspot.getMacAddressOfHost = function (ip) { return; };
    /**
     * Checks if IP is live using DNS
     *
     * @param {string}        ip  - IP Address you want to test
     *
     * @returns {Promise<boolean>} - A Promise for whether the IP Address is reachable
     */
    Hotspot.isDnsLive = function (ip) { return; };
    /**
     * Checks if IP is live using socket And PORT
     *
     * @param {string}        ip  - IP Address you want to test
     *
     * @returns {Promise<boolean>} - A Promise for whether the IP Address is reachable
     */
    Hotspot.isPortLive = function (ip) { return; };
    /**
     * Checks if device is rooted
     *
     * @returns {Promise<boolean>} - A Promise for whether the device is rooted
     */
    Hotspot.isRooted = function () { return; };
    __decorate([
        Cordova()
    ], Hotspot, "isAvailable", null);
    __decorate([
        Cordova()
    ], Hotspot, "toggleWifi", null);
    __decorate([
        Cordova()
    ], Hotspot, "createHotspot", null);
    __decorate([
        Cordova()
    ], Hotspot, "startHotspot", null);
    __decorate([
        Cordova()
    ], Hotspot, "configureHotspot", null);
    __decorate([
        Cordova()
    ], Hotspot, "stopHotspot", null);
    __decorate([
        Cordova()
    ], Hotspot, "isHotspotEnabled", null);
    __decorate([
        Cordova()
    ], Hotspot, "getAllHotspotDevices", null);
    __decorate([
        Cordova()
    ], Hotspot, "connectToWifi", null);
    __decorate([
        Cordova()
    ], Hotspot, "connectToWifiAuthEncrypt", null);
    __decorate([
        Cordova()
    ], Hotspot, "addWifiNetwork", null);
    __decorate([
        Cordova()
    ], Hotspot, "removeWifiNetwork", null);
    __decorate([
        Cordova()
    ], Hotspot, "isConnectedToInternet", null);
    __decorate([
        Cordova()
    ], Hotspot, "isConnectedToInternetViaWifi", null);
    __decorate([
        Cordova()
    ], Hotspot, "isWifiOn", null);
    __decorate([
        Cordova()
    ], Hotspot, "isWifiSupported", null);
    __decorate([
        Cordova()
    ], Hotspot, "isWifiDirectSupported", null);
    __decorate([
        Cordova()
    ], Hotspot, "scanWifi", null);
    __decorate([
        Cordova()
    ], Hotspot, "scanWifiByLevel", null);
    __decorate([
        Cordova()
    ], Hotspot, "startWifiPeriodicallyScan", null);
    __decorate([
        Cordova()
    ], Hotspot, "stopWifiPeriodicallyScan", null);
    __decorate([
        Cordova()
    ], Hotspot, "getNetConfig", null);
    __decorate([
        Cordova()
    ], Hotspot, "getConnectionInfo", null);
    __decorate([
        Cordova()
    ], Hotspot, "pingHost", null);
    __decorate([
        Cordova()
    ], Hotspot, "getMacAddressOfHost", null);
    __decorate([
        Cordova()
    ], Hotspot, "isDnsLive", null);
    __decorate([
        Cordova()
    ], Hotspot, "isPortLive", null);
    __decorate([
        Cordova()
    ], Hotspot, "isRooted", null);
    Hotspot = __decorate([
        Plugin({
            pluginName: 'Hotspot',
            plugin: 'cordova-plugin-hotspot',
            pluginRef: 'cordova.plugins.hotspot',
            repo: 'https://github.com/hypery2k/cordova-hotspot-plugin',
            platforms: ['Android']
        })
    ], Hotspot);
    return Hotspot;
}());
//# sourceMappingURL=hotspot.js.map