angular.module('starter.services', [])

    .factory('feqhiatService', function (constants, $http, $rootScope, utilService, $cordovaSocialSharing,$ionicLoading,$cordovaClipboard) {
        var feqhiatService = {};
        feqhiatService.getAllParam = function (theScope, successFunc) {
            var url = constants.param_url;
            $http({
                method: "GET",
                url: url
            }).success(function (data) {
                var allData = data.data;
                constants.is_admin = true;//allData.is_admin; // TEMP
                constants.user_name = allData.user_name;
                theScope.al_params = allData.params;

                if (successFunc) {
                    //console.log(constants.is_admin + ",  " + constants.user_name);
                    successFunc();
                }

            }).error(function (data, status) {
                if($ionicLoading)
                    $ionicLoading.hide();
                alert("حدث خطأ ، الرجاء التأكد من الشبكة"  + "1");
            });
        };
        feqhiatService.getAllData = function (theScope, successFunc) {
            var url = constants.all_data;
            $http({
                method: "GET",
                url: url
            }).success(function (data) {
                //var allData = data.data;
                theScope.allData = data.data;
                if (successFunc) {
                    console.log("success 2");
                    successFunc();
                }

            }).error(function (data, status) {
                if($ionicLoading)
                    $ionicLoading.hide();
                alert("حدث خطأ ، الرجاء التأكد من الشبكة"  + "2");
            });
        };

        feqhiatService.getProblemList = function (rootScope, theScope, successFunc, problem) {
            //alert(problem.item_id+", "+ problem.book_id +", "+ problem.chapter_id+", "+ problem.faqih_id);
            var url = constants.problem_list;
            if(problem.item_id != undefined)
                url += "&item_id="+problem.item_id;
            if(problem.book_id != undefined)
                url += "&book_id="+problem.book_id;
            if(problem.chapter_id != undefined)
                url += "&chapter_id="+problem.chapter_id;
            if(problem.faqih_id != undefined)
                url += "&faqih_id="+problem.faqih_id;
            if(problem.is_answer != undefined)
                url += "&is_answer="+problem.is_answer;
            if(problem.latest != undefined)
                url += "&latest="+problem.latest;
            if(problem.problem != undefined)
                url += "&problem="+problem.problem;
            if(problem.device_id != undefined)
                url += "&device_id="+problem.device_id;
            //alert(url);

            $http({
                method: "GET",
                url: url
            }).success(function (data) {
                theScope.allData = data.status;
                if (successFunc) {
                    console.log("success 3");
                    successFunc();
                }

            }).error(function (data, status) {
                if($ionicLoading)
                    $ionicLoading.hide();
                alert("حدث خطأ ، الرجاء التأكد من الشبكة"  + "3");
            });
        };

        feqhiatService.getProblemSolutions = function (rootScope, theScope, successFunc) {
            var url = constants.problem_solutions+"&problem_id="+rootScope.problem_id;
            $http({
                method: "GET",
                url: url
            }).success(function (data) {
                theScope.allData = data.status;
                if (successFunc) {
                    console.log("success 4");
                    successFunc();
                }

            }).error(function (data, status) {
                if($ionicLoading)
                    $ionicLoading.hide();
                alert("حدث خطأ ، الرجاء التأكد من الشبكة"  + "4");
            });
        };


        feqhiatService.sendFatwa = function (scopeObj, successFunc, problem) {
            //if (name.trim().length < 1) {
            //    utilService.showAlert("الاسم يجب ان لايكون خاليا");
            //    return;
            //
            //}
            //
            //if (email.trim().length < 1) {
            //    utilService.showAlert("الايميل يجب ان لايكون خاليا");
            //    return;
            //
            //}
            //
            //if (utilService.validateEmail(email) == false) {
            //    utilService.showAlert("الرجاء ادخال الايميل بطريقة صحيحة");
            //    return;
            //}

            if (problem.problem.trim().length < 3) {
                utilService.showAlert("يجب كتابة السؤال قبل الإرسال");
                return;
            }
            if (problem.faqih_id == -1) {
                problem.faqih_id = 1;
            }
            if (problem.book_id == -1) {
                problem.book_id = 0;
            }
            if (problem.chapter_id == -1) {
                problem.chapter_id = 0;
            }
            $ionicLoading.show({
                template: 'الرجاء الانتظار'
            });

            var send_problem_url = constants.send_problem;
            /*console.log()
            var dataTosend={name:problem.name, mobile:problem.mobile, email:problem.email, problem:problem.problem,
                            faqih_id:problem.faqih_id};*/
            Object.toParams = function ObjectToParams(obj) {
                var p = [];
                for (var key in obj) {
                    p.push(key + '=' + encodeURIComponent(obj[key]));
                }
                return p.join('&');
            };
            $http({
                method: 'POST',
                url:send_problem_url,
                data:Object.toParams(problem),
                headers: {'Content-Type': 'application/x-www-form-urlencoded'}
            }).then(function successCallback(data) {
                if(successFunc)
                {
                    successFunc();
                }
            }, function errorCallback(response) {
                alert("حدث خطأ ، الرجاء التأكد من الشبكة"  + "5");
            });


        };

















        feqhiatService.shareFatwa = function (fatwa, social) {
            var bookName = utilService.getBookNameByid(fatwa.bookid);


            var seperator = "----------";
            var shareText = fatwa.title +"\r\n"+ seperator +"\r\n"+ "كتاب : " + bookName+"\r\n" + seperator + "\r\n";
            for (var i = 0; i < fatwa.rais.length; i++) {
                shareText = shareText + fatwa.rais[i].marjaa + "\r\n" + fatwa.rais[i].rai +"\r\nالمصدر:"+ fatwa.rais[i].source +"\r\n"+ seperator;
            }
            shareText = shareText +"\r\n"+ "بواسطة تطبيق فقهيات" + "\r\n" + "للايفون والايباد" + "\r\n" + constants.shareappiosurl + "\r\n" +
            "للاندرويد" + "\r\n" + constants.shareappandroidurl;

            if (social == 'wa') {
                $cordovaSocialSharing
                    .shareViaWhatsApp(shareText)
                    .then(function (result) {
                        // Success!
                    }, function (err) {
                        // An error occurred. Show a message to the user
                    });
            }
            else if (social == 'fb') {
                $cordovaSocialSharing
                    .shareViaFacebook(shareText)
                    .then(function (result) {
                        // Success!
                    }, function (err) {
                        // An error occurred. Show a message to the user
                    });

            }
            else if (social == 'other') {
                $cordovaSocialSharing
                    .share(shareText)
                    .then(function (result) {
                        // Success!
                    }, function (err) {
                        // An error occurred. Show a message to the user
                    });

            }
            else {
                $cordovaClipboard
                    .copy(shareText)
                    .then(function () {
                        // success
                    }, function () {
                        // error
                    });

            }

        };


        feqhiatService.searchFatwas = function (scopeObj, callback, keyword, selectedMarjaa, selectedBook, selectedCat) {
            if (selectedMarjaa == -1) {
                selectedMarjaa = "all";
            }
            if (selectedBook == -1) {
                selectedBook = "all";
            }
            if (selectedCat == -1) {
                selectedCat = "all";
            }

            var searchurl = constants.searchurl + "?mid=" + selectedMarjaa + "&bookid=" + selectedBook + "&catid=" + selectedCat + "&keyword=" + keyword + "&time=" + Date.now();
            $http({
                method: "GET",
                url: searchurl
            }).success(function (data) {
                $rootScope.searchResults = data.fatwas;
                if (callback) {
                    callback();
                }
            }).error(function (data, status) {
                alert("error1 data: " + data + " status: " + status);
            });
        };



        return feqhiatService;
    });
